package gov.va.med.mhv.sm.admin.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import gov.va.med.mhv.sm.admin.model.Annotation;
import gov.va.med.mhv.sm.admin.model.Thread;

@Repository
public interface AnnotationRepository extends JpaRepository<Annotation, Long>{
	
	/**
	 * findAnnotationByThreadById
	 * @param threadId
	 * @return Annotation
	 */
	@Query("select note from Annotation note where threadId = :threadId")
	Annotation findAnnotationByThreadById(@Param("threadId") Long threadId);

}